/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/arPhy.h#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 */

#ifndef __ARPHY_H__
#define __ARPHY_H__

typedef enum {
    WIRELESS_MODE_11a   = 0,
    WIRELESS_MODE_TURBO = 1,
    WIRELESS_MODE_11b   = 2,
    WIRELESS_MODE_11g   = 3,
    WIRELESS_MODE_108g  = 4,
    WIRELESS_MODE_XR    = 5,

    WIRELESS_MODE_MAX
} WIRELESS_MODE;

#define PHY_COMPUTE_TX_TIME(_pRateTbl, _frameLen, _rateIndex, _flag)   \
    phyComputeTxTime[(_pRateTbl)->info[(_rateIndex)].phy](_pRateTbl, _frameLen, _rateIndex, _flag)

typedef enum {
    WLAN_PHY_OFDM  = 0,
    WLAN_PHY_TURBO = 1,
    WLAN_PHY_CCK   = 2,
    WLAN_PHY_XR    = 3,

    WLAN_PHY_MAX
} WLAN_PHY;


/*
 * Rate Table structure for various modes - 'b', 'a', 'g', 'xr';
 * order of fields in info structure is important because hardcoded
 * structures are initialized within the hal for these
 */
typedef struct rateInfo {
        A_BOOL    valid;            // Valid for use in rate control
        WLAN_PHY  phy;              // CCK/OFDM/XR
        A_UINT16  rateKbps;         // Rate in Kbits per second
        A_UINT16  userRateKbps;     // User rate in KBits per second
        A_UINT8   rateCode;         // rate that goes into hw descriptors
        A_UINT8   shortPreamble;    // Mask for enabling short preamble in rate code for CCK
        A_UINT8   dot11Rate;        // Value that goes into supported rates info element of MLME
        A_UINT8   controlRate;      // Index of next lower basic rate, used for duration computation
        A_UINT8   rssiAckValidMin;  // Rate control related information
        A_UINT8   rssiAckDeltaMin;  // Rate control ralated information
        A_UINT16  lpAckDuration;    // Long preamble ACK duration
        A_UINT16  spAckDuration;    // short preamble ACK duration
} RATE_INFO;

#define RATE_TABLE_SIZE             32
typedef struct RateTable {
    int         rateCount;
    A_UINT8     rateCodeToIndex[RATE_TABLE_SIZE]; // backward mapping
    RATE_INFO   info[RATE_TABLE_SIZE];
    A_UINT32    probeInterval;        // interval for ratectrl to probe for other rates
    A_UINT32    rssiReduceInterval;   // interval for ratectrl to reduce RSSI
    A_UINT8     regularToTurboThresh; // upperbound on regular (11a or 11g) mode's rate before switching to turbo
    A_UINT8     turboToRegularThresh; // lowerbound on turbo mode's rate before switching to regular
    A_UINT8     pktCountThresh;       // mode switch recommendation criterion: number of consecutive packets sent at rate beyond the rate threshold
    A_UINT8     initialRateMax;       // the initial rateMax value used in rcSibUpdate()
    A_UINT8     numTurboRates;        // number of Turbo rates in the rateTable
} RATE_TABLE;

typedef A_UINT16 (*PHY_TX_TIME_FUNC)(const RATE_TABLE *, A_UINT32 frameLen, A_UINT16 rateIndex, A_BOOL flag);

extern PHY_TX_TIME_FUNC phyComputeTxTime[WLAN_PHY_MAX];



/* Auto-noise Immunity (ANI) */

#define HAL_NOISE_IMMUNE_MAX        4   /* Maximum noise immunity level */
#define HAL_SPUR_IMMUNE_MAX         2   /* Maximum spur immunity level */
#define HAL_FIRST_STEP_MAX          2   /* Maximum first step level */

#define HAL_ANI_OFDM_TRIG_HIGH      500
#define HAL_ANI_OFDM_TRIG_LOW       200
#define HAL_ANI_CCK_TRIG_HIGH       200
#define HAL_ANI_CCK_TRIG_LOW        100
#define HAL_ANI_NOISE_IMMUNE_LVL    HAL_NOISE_IMMUNE_MAX
#define HAL_ANI_USE_OFDM_WEAK_SIG   1
#define HAL_ANI_CCK_WEAK_SIG_THR    0
#define HAL_ANI_SPUR_IMMUNE_LVL     HAL_SPUR_IMMUNE_MAX
#define HAL_ANI_FIRSTEP_LVL         0
#define HAL_ANI_RSSI_THR_HIGH       40
#define HAL_ANI_RSSI_THR_LOW        7
#define HAL_ANI_PHYERRSTATS_DIS     0
#define HAL_ANI_PERIOD              100


/*
 * Per-channel ANI state private to the driver.
 */
typedef struct arAniState {
    CHANNEL_FREQ channelFreq;
    PHY_MODS     phyModulations;
    
    A_UINT8      noiseImmunityLevel;
    A_UINT8      spurImmunityLevel;
    A_UINT8      firstepLevel;
    A_UINT8      ofdmWeakSigDetectOff;
    A_UINT8      cckWeakSigThreshold;
    A_UINT8      phyErrStatsDisabled;;

    /* Thresholds */
    A_UINT32     listenTime;
    A_INT32      ofdmTrigHigh;
    A_INT32      ofdmTrigLow;
    A_INT32      cckTrigHigh;
    A_INT32      cckTrigLow;
    A_INT32      rssiThrLow;
    A_INT32      rssiThrHigh;

    A_UINT32     noiseFloor;      /* The current noise floor */
    A_UINT32     txFrameCount;    /* Last txFrameCount */
    A_UINT32     rxFrameCount;    /* Last rx Frame count */
    A_UINT32     cycleCount;      /* Last cycleCount (can detect wrap-around\
                                        ) */
    A_UINT32     ofdmPhyErrCount; /* cumulative OFDM phy err count           */
    A_UINT32     cckPhyErrCount;  /* cumulative CCK phy err count            */
    A_UINT32     ofdmPhyErrBase;  /* Base value for ofdm err counter         */
    A_UINT32     cckPhyErrBase;   /* Base value for cck err counters         */
} AR_ANI;

typedef struct ar_AniStats {
    A_UINT32   ast_ani_action; /* ANI actions invoked */
    A_UINT32   ast_ani_poll;   /* ANI poll operations */
    A_UINT32   ast_ani_nifull; /* ANI set noise immunity to full */
    A_UINT32   ast_ani_niup;   /* ANI increased noise immunity */
    A_UINT32   ast_ani_nidown; /* ANI decreased noise immunity */
    A_UINT32   ast_ani_spurup; /* ANI increased spur immunity */
    A_UINT32   ast_ani_spurdown;/* ANI descreased spur immunity */
    A_UINT32   ast_ani_ofdmon; /* ANI OFDM weak signal detect on */
    A_UINT32   ast_ani_ofdmoff;/* ANI OFDM weak signal detect off */
    A_UINT32   ast_ani_cckhigh;/* ANI CCK weak signal threshold high */
    A_UINT32   ast_ani_ccklow; /* ANI CCK weak signal threshold low */
    A_UINT32   ast_ani_stepup; /* ANI increased first step level */
    A_UINT32   ast_ani_stepdown;/* ANI decreased first step level */
    A_UINT32   ast_ani_disable;/* ANI disabled stats collection */
    A_UINT32   ast_ani_enable; /* ANI enabled stats collection */
} AR_ANISTATS;


#endif /* __ARPHY_H__*/
