/*
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 */
#ifndef _ARPOWER_H
#define _ARPOWER_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct pwrMgmtInfo {
    A_UINT32        powerState;             /* Target Power State       */
    A_UINT32        halPwrState;            /* Target MAC Power State   */
    A_UINT32        awakeCount;             /* Awake Count              */    
} AR_PWR_MGMT_INFO;

typedef enum {
    AR_MAC_AWAKE_MODE,
    AR_MAC_SLEEP_MODE,
    AR_MAC_PWRSAVE_MODE
} AR_MAC_PSMODE;

typedef enum {
    AR_DEVICE_SLEEP_MODE,
    AR_DEVICE_NORMAL_MODE
} AR_DEVICE_PSMODE;

extern void
TARG_wdcTargetSetPsMode(TARGET_HANDLE targetHandle, TARGET_POWER_MODE wdcPsMode, A_STATUS *pStatus);


extern A_STATUS
arDevSetPowerMode(TARGET_HANDLE targetHandle, AR_DEVICE_PSMODE devicePwrState);

extern A_STATUS
arMacSetPowerMode(TARGET_HANDLE targetHandle, AR_MAC_PSMODE macPwrState);

extern A_STATUS
arMacSetAwakeMode(TARGET_HANDLE targetHandle, A_UINT8 setAwake);

extern void
arMacInitPsMode (TARGET_HANDLE targetHandle); 


#ifdef __cplusplus
}
#endif


#endif
