/*
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 */

#ifndef _ARRATECTRL_H
#define _ARRATECTRL_H

#include "arDev.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Rate Control Access Functions */

A_UINT16
rcRateFind(AR_DEV_INFO *pArDev, AR_DESC *pDesc);

void
rcUpdate(AR_DEV_INFO *pArDev, AR_CONN_INFO *pSib, int txRate, int frameLen,
         A_BOOL Xretries, int retries, A_UINT8 rssiAck, A_UINT8 curTxAnt);

void
rcSibInit(AR_CONN_INFO *pSib);

void
rcSibUpdate(AR_CONN_INFO *pSib, A_BOOL keepState, AR_DEV_INFO  *pArDev);

A_UINT16
rcGetBestCckRate(AR_DESC *pDesc, A_UINT16 thisRate);


#ifdef __cplusplus
}
#endif

#endif /* _ARRATECTRL_H_ */

