/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/arReceive.h#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 * 
 * Contains defnitions and prototypes relevant to target receive logic.
 */

#ifndef _ARRECEIVE_H_
#define _ARRECEIVE_H_

#include "arDev.h"

#ifdef __cplusplus
extern "C" {
#endif

#define ARDESC_TO_RXBUF(pDesc)    \
    ((pDesc)->pBufferVirtPtr.byte)

/* Given a RX Descriptor, determine where the associated RECEIVE_INFO is. */
#define ARDESC_TO_RECEIVE_INFO(pDesc)   \
    (&((WDC_RXBUF_TO_RXMSG(ARDESC_TO_RXBUF(pDesc)))->receiveInfo))

// LIG: Subtract cacheline size as a defensive measure.
// We won't rely on WDC_RXMSG's to be allocated on cacheline
// boundaries.
#define WDC_RXMSG_DATA_LENGTH     \
    (WDC_RXMSG_LENGTH - WDC_RXMSG_HEADER_LENGTH - CACHE_LINE_SIZE)


A_STATUS
arRxInit(
    AR_DEV_INFO  *pArDev
);

void
arStartReceive(IN AR_DEV_INFO *pArDev);

void
arStopReceive(IN AR_DEV_INFO *pArDev);

/*
 * Process a receive interrupt
 */
void
arNotifyRxComplete(
    IN  AR_DEV_INFO *pArDev
);


void
arRecycleRxBuf(
    IN DEVICE_HANDLE       devHandle,
    IN char                *rxBuf
);

A_BOOL  
arRxCompleteHandler(
    AR_DEV_INFO *pArDev
);

#ifdef __cplusplus
}
#endif

#endif /* _ARRECEIVE_H_ */

