/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/arTransmit.h#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 * 
 * Contains defnitions and prototypes relevant to target receive logic.
 */

#ifndef __ARTRANSMIT_H__
#define __ARTRANSMIT_H__

#include "arDev.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Macro to lock the interrupt on wlan drivers 
 * INIT_WLAN_INTR_LOCK - Initialises the lock, needs to be called 
 *                       at the beginning of the code
 * LOCK_WLAN_INTR      - Locks the WLAN interrupts used intLock on 
 *                       AP and halDisableInterrupts on other builds
 * UNLOCK_WLAN_INTR    - Unlocks the interrtups uses intUnLock on 
 *                       AP and halEnableInterrupts on other builds 
 */


#ifdef BUILD_AP                                            
#define INIT_WLAN_INTR_LOCK(_intKey)  int _intKey = 0;                                   
#define LOCK_WLAN_INTR(_intKey)      _intKey = intLock();                               
#define UNLOCK_WLAN_INTR(_intKey)     intUnlock(_intKey);                                  
#else
#define INIT_WLAN_INTR_LOCK(_intKey)
#define LOCK_WLAN_INTR(_intKey)                           \
        halDisableInterrupts(pArDev, HAL_INT_GLOBAL);    
#define UNLOCK_WLAN_INTR(_intKey)                         \
        halEnableInterrupts(pArDev, HAL_INT_GLOBAL);    
#endif

#define AR_HAL_QUEUE_INFO_INIT(_pQ, _pAc)    do {   \
    A_MEM_ZERO(_pQ, sizeof(HAL_TX_QUEUE_INFO)); \
    (_pQ)->aifs     = (_pAc)->aifs;             \
    (_pQ)->logCwMin = (_pAc)->logCwMin;         \
    (_pQ)->logCwMax = (_pAc)->logCwMax;         \
} while (0)


/*
 * Helper macro useful to splice out a minichain from a chain of
 * frames; pLastTail->next to pThisTail is spliced out - callee
 * should save its own ptr to the spliced out minichain prior to
 * calling this macro; pHead is used if the minichain happens to
 * be at the head of the main chain
 */
#define spliceFrame_HELPER(_ppH, _pLastT, _pThisT)  do {    \
    if (_pLastT) {                                          \
        (_pLastT)->pNextVirtPtr = (_pThisT)->pNextVirtPtr;  \
        (_pLastT)->nextPhysPtr  = (_pThisT)->nextPhysPtr;   \
    } else {                                                \
        (*(_ppH)) = (_pThisT)->pNextVirtPtr;                \
    }                                                       \
    (_pThisT)->pNextVirtPtr = NULL;                         \
    (_pThisT)->nextPhysPtr = 0;                             \
} while (0)

/*
 * Copy tx attributes to HAL tx queue info
 */
#define AR_HAL_QUEUE_INFO_INIT(_pQ, _pAc)    do {           \
    A_MEM_ZERO(_pQ, sizeof(HAL_TX_QUEUE_INFO));             \
    (_pQ)->aifs     = (_pAc)->aifs;                         \
    (_pQ)->logCwMin = (_pAc)->logCwMin;                     \
    (_pQ)->logCwMax = (_pAc)->logCwMax;                     \
} while (0)


/*
 * When to use short preamble for CCK?
 * AP logic may be broken - as we haven't supported a CCK AP
 * as yet! Station side uses it based on capInfo, but uses
 * long preamble for all probe request/response frames
 */
#ifdef BUILD_AP
#define USE_SHORT_PREAMBLE(_pArDev, _pArConn, _pHdr)     \
    ((!(_pArConn)) || !((_pArConn)->options.longPreambleOnly))
#else
#define IS_PROBE_REQRESP_FRAME(_fc)                 \
    (((_fc)->fType == FRAME_MGT) &&                 \
    (((_fc)->fSubtype == SUBT_PROBE_REQ) || ((_fc)->fSubtype == SUBT_PROBE_RESP)))
#define USE_SHORT_PREAMBLE(_pArDev, _pArConn, _pHdr)     \
    (((!(_pArConn)) || !((_pArConn)->options.longPreambleOnly))) && \
     (!IS_PROBE_REQRESP_FRAME(&(_pHdr)->frameControl))
#endif

#define RTS_THRESHOLD(pArDev)  (pArDev)->config.userRTSThreshold

#define ARDESC_TO_TXBUF(pDesc)  \
       ((A_CHAR *)A_DATA_P2V((pDesc)->bufferPhyPtr)) 


#if defined(COMPRESSION_ENABLED)
/* The number of compression buffers to allocate */
#if defined(BURST_ENABLED)
#define COMP_BUF_COUNT      2
#else
#define COMP_BUF_COUNT      1
#endif

/* Number of kilobytes to use for each compression buffer. */
#define COMP_BUF_BYTES         ((2*(A_UINT32)WDC_DATA_MSG_LENGTH_MAX)+128)
#define COMP_BUF_KBS           ((COMP_BUF_BYTES+1023)/1024)

/* Hardware-mandated alignment for compression buffers */
#define COMP_BUF_ALIGN_MASK    0x1ff
#define COMP_BUF_ALIGN_SIZE    512
#endif /* COMPRESSION_ENABLED */


A_STATUS
arTxInit(IN AR_DEV_INFO *pArDev);

void
arStartTransmit(IN AR_DEV_INFO *pArDev);

void
arStopTransmit(IN AR_DEV_INFO *pArDev, DRAIN_ENUM waitForDrain);

void
arRecycleTxBuf(IN DEVICE_HANDLE  devHandle, 
	       IN A_CHAR        *txBuf,
	       IN A_UINT32      bufLength);

void
arNotifyTxComplete(AR_DEV_INFO *pArDev);

void
arFlushTxCompleteMsg(AR_DEV_INFO *pArDev);
void TARG_wdcTxMsgEnqueue(AR_DEV_INFO   *pArDev,
		     WDC_TXMSG     *txMsg);

void
TARG_wdcTxMsgFlushqueue(AR_DEV_INFO   *pArDev);
void arTxCompleteHandler(
    AR_DEV_INFO *pArDev
);

#ifdef __cplusplus
}
#endif

#endif /* __ARTRANSMIT_H__ */

