/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/masterInfo.h#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/*
 * Definitions shared between WDC and WDC Messaging layer.
 */

#ifndef __INC_MASTERINFO_H
#define __INC_MASTERINFO_H

/*
 * This is used to allocate space for incoming Control Messages
 * and to allocate Message Dispatch Queue items.
 */
#define CTRL_MSG_INCOMING_COUNT 2

/*
 * The number of Control Messages to be allocated for
 * outgoing Control Messages (to Host).
 * 
 * Reserve a sufficient number of outgoing messages to allow
 * for a response for each incoming message PLUS a few extra
 * for any asynchronous messages that we may wish to send.
 *
 * 11 Data TX + 2 Ctrl + 2 Async + 1 Fudge
 */

#define CTRL_MSG_OUTGOING_COUNT 16

extern A_STATUS TARG_wdcCtrlMsgQInit(MASTER_HANDLE masterHandle);
extern void TARG_wdcCtrlMsgEnqueue(MASTER_HANDLE masterHandle, WDC_MSG *wdcMsg);
extern WDC_MSG *TARG_wdcCtrlMsgDequeue(MASTER_HANDLE masterHandle);
extern void TARG_wdcCtrlMsgDispatchLoop(MASTER_HANDLE masterHandle);
extern void TARG_wdcCtrlMsgRecv(WDC_MSG *wdcMsg);

#endif /* __INC_MASTERINFO_H */
