/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/targTransport.h#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */


#ifndef __INC_TARGTRANSPORT_H
#define __INC_TARGTRANSPORT_H

/* Tranport Events export to the caller */
typedef enum {
    TXPORT_SLEEP_EVENT,
    TXPORT_WAKE_EVENT,
    TXPORT_RESET_EVENT,
    TXPORT_INIT_EVENT
} TXPORT_PLATFORM_EVENT;

typedef void * TARG_PLATFORM_EVENT_HANDLE;
/* Event handler which is to be registered with the Target Layer */
typedef void (*TARG_PLATFORM_EVENT_HANDLER)(TARG_PLATFORM_EVENT_HANDLE, TXPORT_PLATFORM_EVENT);


extern void
TARG_txportRegisterPSEvent(
    MASTER_MSG_HANDLE           masterMsgHandle,
    TARG_PLATFORM_EVENT_HANDLER targEventHandler,
    TARG_PLATFORM_EVENT_HANDLE  targEventHandle 
    );


extern void
TARG_txportDisable(
    MASTER_MSG_HANDLE           masterMsgHandle
    );

extern void
TARG_txportEnable(
    MASTER_MSG_HANDLE           masterMsgHandle
    );

void
TARG_txportPoll(
    MASTER_MSG_HANDLE           masterMsgHandle
    );

void
TARG_txportPollDisable(
    MASTER_MSG_HANDLE           masterMsgHandle
    );


void
TARG_txportPollEnable(
    MASTER_MSG_HANDLE           masterMsgHandle
    );


A_UINT32
TARG_txportGetLineState(
    MASTER_MSG_HANDLE           masterMsgHandle
    );

#endif /* __INC_TARGTRANSPORT_H */

