/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/targWdc.h#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */


#ifndef __INC_TARGWDC_H
#define __INC_TARGWDC_H

/* Target-Side WDC private definitions */

/* Linkage for messages in the Control Message Dispatch Queue.  */
struct CtrlMsgQ {
    TAILQ_ENTRY(CtrlMsgQ)  Qlinkage;
    WDC_MSG                *wdcMsg;
};
TAILQ_HEAD(CtrlMsgQHead_s, CtrlMsgQ);


/* Linkage for TX Messages in the TX Message Dispatch Queue. */
struct TxMsgQ {
    TAILQ_ENTRY(TxMsgQ)    Qlinkage;
    WDC_TXMSG              *txMsg;
};
TAILQ_HEAD(TxMsgQHead_s, TxMsgQ);


/* Linkage for Async Events in the AsyncEvt Dispatch Queue. */
struct AsyncEvtQ {
    TAILQ_ENTRY(AsyncEvtQ) Qlinkage;
    A_UINT32               event;
    void                   *opaque;  // TBD
};
TAILQ_HEAD(AEvtQHead_s, AsyncEvtQ);


/*
 * This is per-master information kept on the target-side by the WDC.
 * The MASTER_HANDLE passed between WDC and messaging layer is a pointer
 * to one of these.
 */
typedef struct per_master_info {
    MASTER_MSG_HANDLE     masterMsgHandle; /* Whatever data the target needs
                                              in order to access the master */

    DEVICE_HANDLE         deviceHandle;    /* Driver cookie, opaque to
                                              all WDC code. */

    PLATFORM_HANDLE       platformHandle;  /* Platform Handle opaque to
                                              WDC code */
    /* CONTROL QUEUE */
    /* Control Messages sent from Host to Target */
    A_CNTSEM_TYPE         CtrlMsgQSem;     /* Control Msg Q Semaphore */

    struct CtrlMsgQHead_s CtrlMsgQHead;    /* Control Message Queue */

    struct CtrlMsgQHead_s CtrlMsgQFree;    /* Free list for CMQ */


    A_CNTSEM_TYPE         TxMsgQSem;       /* TX Msg Q count.  TX Message
                                              dispatcher sleeps on this until
                                              new data is added to the
					      queue. */

    struct TxMsgQHead_s   TxMsgQHead;      /* TX Message Queue */

    struct TxMsgQHead_s   TxMsgQFree;      /* Free list for TMQ */

    A_CNTSEM_TYPE         AsyncEvtQSem;    /* Async Events Q count */
    struct AEvtQHead_s    AsyncEvtQHead;
    struct AEvtQHead_s    AsyncEvtQFree;
    A_CNTSEM_TYPE         AsyncEvtQFreeSem;


} PER_MASTER_INFO;

/*
 * Target-side definitions that are equivalent to the wdcApi.h definitions.
 * Eventually, these may go away.  But as long as we use PCI with
 * memory-based messaging as a test platform, we include both a host-side
 * wdcXXX and a target-side TARG_wdcXXX function.  They need to coexist
 * in a single binary. [We could play some simple pre-processor tricks
 * in order to use wdcApi.h for both host and target.]
 */
void
TARG_wdcInit(void);

void
TARG_wdcHostAvailable(
    IN  MASTER_HANDLE       masterHandle,
    IN  DEVICE_HANDLE       deviceHandle,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcBind(
    IN  MASTER_HANDLE       masterHandle,
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            hostApiVersion,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcUnbind(
    IN  MASTER_HANDLE       masterHandle,
    IN  DEVICE_HANDLE       deviceHandle
);


void
TARG_wdcDeviceDiscovered(
    IN  DEVICE_DATA      devData,
    OUT A_STATUS         *pStatus
);

void
TARG_wdcDeviceRemoved(
    IN  DEVICE_DATA      devData,
    OUT A_STATUS         *pStatus
);

void
TARG_wdcTargetGetCapability(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  TARGET_CAP_ID       capId,
    OUT A_UINT32            *pCapSz,
    OUT TARGET_CAP_DATA     *pCapData,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetSetConfiguration(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  TARGET_CONFIG_ID    attrId,
    IN  A_UINT32            cfgSz,
    IN  TARGET_CONFIG_VAL   cfgVal,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetGetStatus(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  TARGET_STATUS_ID    statusId,
    OUT A_UINT32            *statusSz,
    OUT TARGET_STATUS_DATA  *statusData,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetStart(
    IN  DEVICE_HANDLE       deviceHandle,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetStop(
    IN  DEVICE_HANDLE       deviceHandle,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetDisable(
    IN  DEVICE_HANDLE       deviceHandle,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetEnable(
    IN  DEVICE_HANDLE       deviceHandle,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetSetChannel(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  CHANNEL_BAND        channelBand,
    IN  CHANNEL_FREQ        channelFrequency,
    IN  PHY_MODS            phyModulations,
    IN  A_UINT32            maxRDPower,
    IN  A_UINT32            cfgCtl,
    IN  A_UINT32            twiceAntennaReduction,
	IN  A_BOOL              keepRCContent,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcTargetReset(
    IN  DEVICE_HANDLE       deviceHandle,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcStaJoinBss(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcBssId,
    IN  WLAN_MACADDR        *pBssId,
    IN  WDC_BSS_ATTRIBUTES  *pBssConfig
);

void
TARG_wdcStaAssocBss(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcBssId,
    IN  A_UINT16            assocId
);

void
TARG_wdcStartBss(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcBssId,
    IN  WDC_BUFFER_DESC     *pBeaconTemplate
);

void
TARG_wdcUpdateBssAttribute(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcBssId,
    IN  WDC_BSS_ATTRIBUTE   attribute,
    IN  A_UINT32            cfgSize,
    IN  TARGET_CONFIG_VAL   cfgVal
);

void
TARG_wdcUpdateBssIe(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcBssId,
    IN  INFO_ELEMENT        *pIe
);

void
TARG_wdcDetachBss(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_UINT32            wdcBssId
);

void
TARG_wdcCreateConnection(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  WLAN_MACADDR        *pMacAddr,
    IN  A_UINT32            wdcConnId,
    IN  A_UINT32            wdcBssId,
    IN  CONN_ATTRIBUTES     *pOptions
);
void
TARG_wdcUpdateConnectionAttribute(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcConnId,
    IN  CONN_ATTRIBUTE      attribute,
    IN  A_UINT32            cfgSz,
    IN  TARGET_CONFIG_VAL   cfgVal
);

void
TARG_wdcSetConnectionKey(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcConnId,
    IN  A_UINT32            keyType,
    IN  A_UINT32            keySize,            /* in bytes */
    IN  A_UCHAR             *pKeyMaterial
);

void
TARG_wdcGetConnectionStats(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcConnId,
    OUT CONN_STATS          *pConnStats
);

void
TARG_wdcDeleteConnection(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcConnId
);

void
TARG_wdcInitTxQueues(
    IN  DEVICE_HANDLE       deviceHandle
);

void
TARG_wdcSetupTxQueue(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcTxQueueId,
    IN  TXQ_ATTRIBUTES     *pTxQueueInfo
);

void
TARG_wdcFiniTxQueues(
    IN DEVICE_HANDLE        deviceHandle
);

void
TARG_wdcUpdateTxQueueAttribute(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            wdcTxQueueId,
    IN  TXQ_ATTRIBUTE       attribute,
    IN  A_UINT32            value
);

void
TARG_wdcSetRxFilter(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  RX_FILTER_FLAGS     rxFilter,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcInitRxMulticastFilter(
    DEVICE_HANDLE           deviceHandle,
    A_BOOL                  bReset
);

void
TARG_wdcSetRxMulticastFilter(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  WLAN_MACADDR        *pMcastAddr,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcClearRxMulticastFilter(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  WLAN_MACADDR        *pMcastAddr,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcRegisterEventHandler(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  WDC_EVENT           event,
    IN  EVENT_HANDLER       *pHandler,
    IN  void *              param,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcGetEventHandler(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  WDC_EVENT           event,
    OUT EVENT_HANDLER       **ppHandler,
    OUT void *              *pParam,
    OUT A_STATUS            *pStatus
);

void
TARG_wdcRestoreInfo(
    IN  DEVICE_HANDLE       deviceHandle,
    IN  A_UINT32            infoSize,
    IN  A_UCHAR             *pInfo
);

void
TARG_wdcSetLedState(
      IN  DEVICE_HANDLE     deviceHandle, 
      IN  A_UINT32          ledState);

void
TARG_wdcBmissAck(
      IN  DEVICE_HANDLE     deviceHandle, 
      IN  A_BOOL            bEnable);

void
TARG_wdcSetLedSteadyMode(
    IN  DEVICE_HANDLE       deviceHandle, 
    IN  A_UINT32            ledNumber,
    IN  A_UINT32            mode);

void
TARG_wdcSetLedBlinkMode(
    IN  DEVICE_HANDLE       deviceHandle, 
    IN  A_UINT32            ledNumber,
    IN  A_UINT32            ledMode,
    IN  A_UINT32            blinkRate,
    IN  A_UINT32            slowMode);

#endif /* __INC_TARGWDC_H */
