/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/src/arCap.c#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/* Target-side capability support */

#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "arMsgApi.h"
#include "arDev.h"
#include "halApi.h"
#include "hal.h"
#include "queue.h"
#include "targWdc.h"

void
TARG_wdcTargetGetCapability(
    DEVICE_HANDLE       deviceHandle,
    TARGET_CAP_ID       capId,
    A_UINT32            *pCapSz,
    TARGET_CAP_DATA     *pCapData,
    A_STATUS            *pStatus
)
{
    AR_DEV_INFO              *pArDev = (AR_DEV_INFO *)deviceHandle;
    A_UINT32                 capData = 0;
    A_UINT32                 capSz = 0;
    A_STATUS                 status = A_OK;

    switch(capId) {
    case CAP_TARGET_VERSION:
        capData = pArDev->hwInfo.targetVersion;
        break;

    case CAP_TARGET_REVISION:
        capData = pArDev->hwInfo.targetRevision;
        break;

    case CAP_MAC_VERSION:
        capData = pArDev->hwInfo.macVersion;
        break;

    case CAP_MAC_REVISION:
        capData = pArDev->hwInfo.macRevision;
        break;

    case CAP_PHY_REVISION:
        capData = pArDev->hwInfo.phyRevision;
        break;

    case CAP_ANALOG_5GHz_REVISION:
        capData = pArDev->hwInfo.analog5GhzRevision;
        break;

    case CAP_ANALOG_2GHz_REVISION:
        capData = pArDev->hwInfo.analog2GhzRevision;
        break;

    case CAP_DEBUG_WDCMSG_SUPPORT:
#if defined(WDC_TARGET_DEBUG)
        capData = 1;
#else
        capData = 0;
#endif
        break;

    case CAP_REG_DOMAIN:
        capData = (A_UINT32)(pArDev->hwInfo.regDomain);
        break;

    case CAP_COUNTRY_CODE:
        capData = (A_UINT32)(pArDev->hwInfo.countryCode);
        break;

    case CAP_REG_CAP_BITS:
        capData = (A_UINT32)(pArDev->hwInfo.regCapBits);
        break;

    case CAP_WIRELESS_MODES:
        capData = pArDev->hwInfo.wirelessModes;
        break;

    case CAP_CONNECTION_ID_MAX:
        capData = A_MIN(AR_MAX_CONN, pArDev->hwInfo.keyCacheSize-1);
        break;

    case CAP_TX_QUEUE_ID_MAX:
        capData = pArDev->hwInfo.numTxQueues-1;
        break;

    case CAP_CHAN_SPREAD_SUPPORT:
        capData = pArDev->hwInfo.chanSpreadSupport;
        break;

    case CAP_COMPRESS_SUPPORT:
#if defined(COMPRESSION_ENABLED)
        capData = pArDev->hwInfo.compressSupport;
#else
        capData = 0;
#endif
        break;

    case CAP_BURST_SUPPORT:
#if defined(BURST_ENABLED)
        capData = pArDev->hwInfo.burstSupport;
#else
        capData = 0;
#endif
        break;

    case CAP_FAST_FRAMES_SUPPORT:
        //capData = pArDev->hwInfo.fastFramesSupport;
        capData = 0;
        break;

    case CAP_CHAP_TUNING_SUPPORT:
        capData = pArDev->hwInfo.chapTuningSupport;
        break;

    case CAP_TURBOG_SUPPORT:
        capData = pArDev->hwInfo.turboGSupport;
        break;

    case CAP_TURBO_PRIME_SUPPORT:
        capData = pArDev->hwInfo.turboPrimeSupport;
        break;

    case CAP_DEVICE_TYPE:
        capData = pArDev->hwInfo.deviceType;
        break;

    case CAP_LOW_2GHZ_CHAN:
        capData = pArDev->hwInfo.low2GhzChan;
        break;

    case CAP_HIGH_2GHZ_CHAN:
        capData = pArDev->hwInfo.high2GhzChan;
        break;

    case CAP_LOW_5GHZ_CHAN:
        capData = pArDev->hwInfo.low5GhzChan;
        break;

    case CAP_HIGH_5GHZ_CHAN:
        capData = pArDev->hwInfo.high5GhzChan;
        break;

    case CAP_CIPHER_WEP:
        capData = (A_UINT32)TRUE;
        break;

    case CAP_CIPHER_AES_OCB:
        capData = (A_UINT32)TRUE;
        break;

    case CAP_CIPHER_AES_CCM:
        capData = (A_UINT32)(pArDev->hwInfo.supportCipherAES_CCM);
        break;

    case CAP_CIPHER_TKIP:
        capData = (A_UINT32)(pArDev->hwInfo.supportCipherTKIP);
        break;

    case CAP_CIPHER_CKIP:
        capData = (A_UINT32)(pArDev->hwInfo.supportCipherCKIP);
        break;

    case CAP_MIC_CKIP:
        capData = (A_UINT32)(pArDev->hwInfo.supportMicCKIP);
        break;

    case CAP_MIC_TKIP:
        capData = (A_UINT32)(pArDev->hwInfo.supportMicTKIP);
        break;

    case CAP_MIC_AES_CCM:
        capData = (A_UINT32)(pArDev->hwInfo.supportMicAES_CCM);
        break;

    case CAP_TWICE_ANTENNAGAIN_5G:
        capData = (A_UINT32)(pArDev->hwInfo.twiceAntennaGain5G);
        break;

    case CAP_TWICE_ANTENNAGAIN_2G:
        capData = (A_UINT32)(pArDev->hwInfo.twiceAntennaGain2G);
        break;

    default:
        ASSERT(0); /* Unknown capability */
        status = A_EINVAL;
        break;
    }

    if (status == A_OK) {
        if (capSz == 0) {
            if (pCapData) {
                *pCapData = (TARGET_CAP_DATA)capData;
            }
        }

        if (pCapSz) {
            *pCapSz = capSz;
        }
    }

    if (pStatus) {
        *pStatus = status;
    }
}
