/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/src/arPhy.c#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 */



#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "arMsgApi.h"
#include "arDev.h"
#include "halApi.h"
#include "hal.h"

#if defined(ECOS_NOTDONE)

// XXX: This comes from host/wlanPhy

static A_UINT16
ofdmComputeTxTime(const RATE_TABLE *pRateTable, A_UINT32 frameLen, A_UINT16 rateIndex, A_BOOL flag)
{
    A_UINT32 kbps    = pRateTable->info[rateIndex].rateKbps;
    A_UINT32 bitsPerSymbol, numBits, numSymbols, txTime;

#define OFDM_SIFS_TIME        16
#define OFDM_PREAMBLE_TIME    20
#define OFDM_PLCP_BITS        22
#define OFDM_SYMBOL_TIME       4

    bitsPerSymbol = (kbps * OFDM_SYMBOL_TIME) / 1000;

    numBits       = OFDM_PLCP_BITS + (frameLen << 3);
    numSymbols    = (numBits + bitsPerSymbol - 1) / bitsPerSymbol;
    txTime        = OFDM_SIFS_TIME + OFDM_PREAMBLE_TIME + (numSymbols * OFDM_SYMBOL_TIME);

    return (A_UINT16)txTime;
}


static A_UINT16
turboComputeTxTime(const RATE_TABLE *pRateTable, A_UINT32 frameLen, A_UINT16 rateIndex, A_BOOL flag)
{
    A_UINT32 kbps    = pRateTable->info[rateIndex].rateKbps;
    A_UINT32 bitsPerSymbol, numBits, numSymbols, txTime;

#define TURBO_SIFS_TIME         8
#define TURBO_PREAMBLE_TIME    14
#define TURBO_PLCP_BITS        22
#define TURBO_SYMBOL_TIME       4

    /* we still save OFDM rates in kbps - so double them */
    bitsPerSymbol = ((kbps << 1) * TURBO_SYMBOL_TIME) / 1000;

    numBits       = TURBO_PLCP_BITS + (frameLen << 3);
    numSymbols    = (numBits + bitsPerSymbol - 1) / bitsPerSymbol;
    txTime        = TURBO_SIFS_TIME + TURBO_PREAMBLE_TIME + (numSymbols * TURBO_SYMBOL_TIME);

    return (A_UINT16)txTime;
}


static A_UINT16
cckComputeTxTime(const RATE_TABLE *pRateTable, A_UINT32 frameLen, A_UINT16 rateIndex, A_BOOL shortPreamble)
{
    A_UINT32 kbps    = pRateTable->info[rateIndex].rateKbps;
    A_UINT32 numBits = frameLen << 3;
    A_UINT32 phyTime, txTime;

#define CCK_SIFS_TIME        10
#define CCK_PREAMBLE_BITS   144
#define CCK_PLCP_BITS        48

    phyTime = CCK_PREAMBLE_BITS + CCK_PLCP_BITS;
    if (shortPreamble && pRateTable->info[rateIndex].shortPreamble) {
        phyTime >>= 1;
    }

    txTime = CCK_SIFS_TIME + phyTime + ((numBits * 1000)/kbps);

    return (A_UINT16)txTime;
}


static A_UINT16
xrComputeTxTime(const RATE_TABLE *pRateTable, A_UINT32 frameLen, A_UINT16 rateIndex, A_BOOL flag)
{
    A_UINT32 kbps    = pRateTable->info[rateIndex].rateKbps;
    A_UINT32 bitsPerSymbol, numBits, numSymbols, txTime;

#define XR_SIFS_TIME            16
#define XR_PREAMBLE_TIME(_kpbs) (((_kpbs) < 1000) ? 173 : 76)
#define XR_PLCP_BITS            22
#define XR_SYMBOL_TIME           4

    bitsPerSymbol = (kbps * XR_SYMBOL_TIME) / 1000;

    numBits       = XR_PLCP_BITS + (frameLen << 3);
    numSymbols    = (numBits + bitsPerSymbol - 1) / bitsPerSymbol;
    txTime        = XR_SIFS_TIME + XR_PREAMBLE_TIME(kbps) + (numSymbols * XR_SYMBOL_TIME);

    return (A_UINT16)txTime;
}


PHY_TX_TIME_FUNC
phyComputeTxTime[WLAN_PHY_MAX] = {
    ofdmComputeTxTime,
    turboComputeTxTime,
    cckComputeTxTime,
    xrComputeTxTime
};

#endif
