/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/src/arStatus.c#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/* Target-side status support */

#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "arMsgApi.h"
#include "arDev.h"
#include "halApi.h"
#include "hal.h"
#include "queue.h"
#include "targWdc.h"

void
TARG_wdcTargetGetStatus(
    DEVICE_HANDLE       deviceHandle,
    TARGET_STATUS_ID    statusId,
    A_UINT32            *pStatusSz,
    TARGET_STATUS_DATA  *pStatusData,
    A_STATUS            *pStatus
)
{
    AR_DEV_INFO              *pArDev = (AR_DEV_INFO *)deviceHandle;
    A_UINT32                 statusData = 0;
    A_UINT32                 statusSz = 0;
    A_STATUS                 status = A_OK;
    WDC_ALL_STATUS           *allStatus = (TARGET_STATUS_DATA)pStatusData;

    switch(statusId) {
    case ST_ALL: {

        statusSz = sizeof(allStatus->devStatus) +
                   sizeof(allStatus->devConfig);

        if (allStatus) {
            ASSERT(statusSz + WDCMSG_HEADER_LENGTH < WDC_MSG_LENGTH_MAX);
            A_DRIVER_BCOPY(&pArDev->devStatus,
                           &allStatus->devStatus,
                           sizeof(allStatus->devStatus));

            A_DRIVER_BCOPY(&pArDev->config,
                           &allStatus->devConfig,
                           sizeof(allStatus->devConfig));
        }
        break;
    }

    case ST_SERVICE_TYPE:
        statusData = CURRENT_SERVICE_TYPE(pArDev);
        break;

    case ST_WLAN_MODE:
        statusData = CURRENT_WLAN_MODE(pArDev);
        break;

    case ST_FREQ:
        statusData = CURRENT_FREQ(pArDev);
        break;

    case ST_LAST_RSSI:
        statusData = pArDev->phyHwLastRssi;
        break;

    case ST_PS_FRAMES_DROPPED:
        statusData = pArDev->psFramesDropped;
        break;

    case ST_CACHED_DEF_ANT:
        statusData = pArDev->cachedDefAnt;
        break;

    case ST_COUNT_OTHER_RX_ANT:
        statusData = pArDev->countOtherRxAnt;
        break;

    case ST_USE_FAST_DIVERSITY:
        statusData = pArDev->useFastDiversity;
        break;

    case ST_MAC_ADDR:
        statusSz = WLAN_MAC_ADDR_SIZE;
        if (pStatusData) {
            A_DRIVER_BCOPY(&pArDev->config.macPermAddr,
                           pStatusData,
                           statusSz);
        }
        break;

    case ST_RX_GENERATION_NUM:
        statusData = pArDev->RxGenerationNum;
        break;

    case ST_SERIAL_NUMBER:
        statusSz = SERIAL_NUMBER_SIZE;
        if (pStatusData) {
            halGetSerialNumber(pArDev, (A_CHAR *)pStatusData, 
                               SERIAL_NUMBER_SIZE);
        }
        break;

    default:
        ASSERT(0); /* Unknown Status ID */
        status = A_EINVAL;
        break;
    }

    if (status == A_OK) {
        if (statusSz == 0) {
            if (pStatusData) {
                *pStatusData = (TARGET_STATUS_DATA)statusData;
            }
        }

        if (pStatusSz) {
            *pStatusSz = statusSz;
        }
    }

    if (pStatus) {
        *pStatus = status;
    }
}
