/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/src/targApp.c#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

#if defined(ECOS)

#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "arMsgApi.h"
#include "arDev.h"
#include "halApi.h"
#include "hal.h"
#include "queue.h"
#include "targWdc.h"
#include "arReceive.h"
#include "arTransmit.h"
#include "arDesc.h"


int asserts = 1;

#if defined(DEBUG) || defined(ECOS_NOTDONE)
A_CHAR *
basename(A_CHAR *filename) {
    A_CHAR *pcTmp;
    A_CHAR *pcLast = filename;
    
    pcTmp = filename;

    while (*pcTmp != '\0') {
	if ((*pcTmp == '/') || (*pcTmp == '\\'))
	    pcLast = (pcTmp + 1);
	pcTmp++;
    }

    return(pcLast);
}
#endif

/*
 * This is the eCos entry point to Atheros target-side software.
 */
void
cyg_user_start(void)
{
    A_STATUS         status;

    uiPrintf("\n--\nImage compiled on %s %s\n",  __DATE__, __TIME__);

    {
        extern int      TX_OUTSTANDING_COUNT;
        extern int      RX_OUTSTANDING_COUNT;
        struct mallinfo mem_info = mallinfo();
        int             reservedKB = 32; /* KBs */


#if defined(COMPRESSION_ENABLED)
        reservedKB += ((COMP_BUF_COUNT * COMP_BUF_KBS) + 1);
#endif /* COMPRESSION_ENABLED */

        // Reserve space for various other data
        TX_OUTSTANDING_COUNT = 
        RX_OUTSTANDING_COUNT = ((mem_info.fordblks - (reservedKB * 1024)) / 
            ((WDC_DATA_MSG_LENGTH_MAX + sizeof(AR_DESC)))) / 2;

#if defined(OVERLAPPING_RX_BUFFERS) 
        {
            int iTmp = (((WDC_DATA_MSG_LENGTH_MAX - 1600) * 
                         (RX_OUTSTANDING_COUNT)) / 
                        WDC_DATA_MSG_LENGTH_MAX) / 2;
            TX_OUTSTANDING_COUNT += iTmp;
            RX_OUTSTANDING_COUNT += iTmp;
        }
#endif

        diag_printf("Memory used: %d Free: %d [Buffers Tx: %d  Rx: %d]\n\n", 
                 mem_info.uordblks,
                 mem_info.fordblks,
                 TX_OUTSTANDING_COUNT,
                 RX_OUTSTANDING_COUNT);
    }

#if defined(AR5523)
    /*
     * On the AR5523, the Atheros device is always present and
     * at a fixed location.
     */
    TARG_wdcDeviceDiscovered((DEVICE_DATA)AR5523_WLAN, &status);
#endif

    return;

}


#endif // defined(ECOS)
