/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/src/targTransport.c#4 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * This file contains the routines to handle power management functionality of the 
 * target
 */
#include "wlantype.h"
#include "queue.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "arDev.h"
#include "targWdc.h"
#include "masterInfo.h"
#include "athusbdrv.h"
#include "targTransport.h"
#include "targMsg.h"

extern A_UINT8 poll;
void  
TARG_txportSuspendHandler(
    APP_HANDLE   appHandle
    )
{
    MASTER_MSG_HANDLE masterMsgHandle = (MASTER_MSG_HANDLE)appHandle;
    
    if (masterMsgHandle->targEventHandler) {
        (masterMsgHandle->targEventHandler) (masterMsgHandle->targEventHandle, 
                                             TXPORT_SLEEP_EVENT);
    }
}

void  
TARG_txportResumeHandler(
    APP_HANDLE   appHandle
    )
{
    MASTER_MSG_HANDLE masterMsgHandle = (MASTER_MSG_HANDLE)appHandle;

    if (masterMsgHandle->targEventHandler) {
        (masterMsgHandle->targEventHandler) (masterMsgHandle->targEventHandle, 
                                             TXPORT_WAKE_EVENT);
    }
}

void  
TARG_txportResetHandler(
    APP_HANDLE   appHandle
    )
{
    MASTER_MSG_HANDLE masterMsgHandle = (MASTER_MSG_HANDLE)appHandle;

    if (masterMsgHandle->targEventHandler) {
        (masterMsgHandle->targEventHandler) (masterMsgHandle->targEventHandle, 
                                             TXPORT_RESET_EVENT);
    }
}
    
void  
TARG_txportInitHandler(
    APP_HANDLE   appHandle
    )
{
    MASTER_MSG_HANDLE masterMsgHandle = (MASTER_MSG_HANDLE)appHandle;

    if (masterMsgHandle->targEventHandler) {
        (masterMsgHandle->targEventHandler) (masterMsgHandle->targEventHandle, 
                                             TXPORT_INIT_EVENT);
    }
}


void
TARG_txportRegisterPSEvent(
    MASTER_MSG_HANDLE           masterMsgHandle,
    TARG_PLATFORM_EVENT_HANDLER targEventHandler,
    TARG_PLATFORM_EVENT_HANDLE  targEventHandle 
    )
{
    A_STATUS     status;

    ASSERT (targEventHandler);
    ASSERT (targEventHandle);

    masterMsgHandle->targEventHandler = targEventHandler;
    masterMsgHandle->targEventHandle  = targEventHandle;

    status = athUsbDrvRegEventHndlr( masterMsgHandle->drvHandle, 
                                     DRV_SUSPEND_EVENT, TARG_txportSuspendHandler);
    if (status != A_OK) {
        ASSERT(0); /* TBD */
    }
    status = athUsbDrvRegEventHndlr( masterMsgHandle->drvHandle, 
                                     DRV_RESUME_EVENT,  TARG_txportResumeHandler);
    if (status != A_OK) {
        ASSERT(0); /* TBD */
    }
    status = athUsbDrvRegEventHndlr( masterMsgHandle->drvHandle, 
                                     DRV_RESET_EVENT,  TARG_txportResetHandler);
    if (status != A_OK) {
        ASSERT(0); /* TBD */
    }
    status = athUsbDrvRegEventHndlr( masterMsgHandle->drvHandle, 
                                     DRV_INIT_EVENT,  TARG_txportInitHandler);
    if (status != A_OK) {
        ASSERT(0); /* TBD */
    }
}



void
TARG_txportDisable(
    MASTER_MSG_HANDLE           masterMsgHandle
    )
{
    A_STATUS     status;
    
    status = athUsbDrvDisable(masterMsgHandle->drvHandle);

    if (status != A_OK) {
        ASSERT(0); /* TBD */
    }
}


void
TARG_txportEnable(
    MASTER_MSG_HANDLE           masterMsgHandle
    )
{
    A_STATUS     status;
    status = athUsbDrvEnable(masterMsgHandle->drvHandle);

    if (status != A_OK) {
        ASSERT(0); /* TBD */
    }
}

void
TARG_txportPoll(
    MASTER_MSG_HANDLE           masterMsgHandle
    )
{
    athUsbDrvPoll(masterMsgHandle->drvHandle);
    return;
}

void
TARG_txportPollDisable(
    MASTER_MSG_HANDLE           masterMsgHandle
    )
{
    /* Enable interrupts */
	poll = 0;
    TARG_txportEnable(masterMsgHandle);
    /* Poll it again to clear off any pending elements */
    TARG_txportPoll(masterMsgHandle);

    return;
}

void
TARG_txportPollEnable(
    MASTER_MSG_HANDLE           masterMsgHandle
    )
{
    /* Disable interrupts */
    TARG_txportDisable(masterMsgHandle);
	poll = 0;
}


A_UINT32
TARG_txportGetLineState(
    MASTER_MSG_HANDLE           masterMsgHandle
    )
{
    return(athUsbDrvGetLineState(masterMsgHandle->drvHandle));
}

