/*
 * Copyright (c) 2004 Atheros Communications, Inc.
 * All rights reserved.
 *
 */

#ifndef _DEV_ATH_AHB_H_
#define _DEV_ATH_AHB_H_

#define AR531X_WLAN0_NUM       0
#define AR531X_WLAN1_NUM       1
#define AR531X_IRQ_WLAN0_INTRS 2
#define AR531X_IRQ_WLAN1_INTRS 5
#define AR531X_WLAN0           0xb8000000
#define AR531X_WLAN1           0xb8500000
#define AR531X_WLANX_LEN       0x000ffffc

#define AR531X_ENABLE          0xbc003080
#define AR531X_ENABLE_WLAN1    0x8
#define AR531X_ENABLE_WLAN0    0x1
#define AR531X_RADIO_MASK_OFF  0xc8
#define AR531X_RADIO0_MASK     0x0003
#define AR531X_RADIO1_MASK     0x000c
#define AR531X_RADIO1_S        2

#define BUS_DMA_FROMDEVICE     0
#define BUS_DMA_TODEVICE       1

#define AR531X_APBBASE         0xbc000000
#define AR531X_RESETTMR	       (AR531X_APBBASE  + 0x3000)
#define AR531X_REV             (AR531X_RESETTMR + 0x0090) /* revision */
#define AR531X_REV_MAJ         0x00f0
#define AR531X_REV_MAJ_S       4
#define AR531X_REV_MIN         0x000f
#define AR531X_REV_MIN_S       0

#define AR531X_BD_MAGIC 0x35333131   /* "5311", for all 531x platforms */

/* set bus cachesize in 4B word units */
inline void bus_dma_sync_single(void *hwdev,
				dma_addr_t dma_handle,
				size_t size, int direction);
inline dma_addr_t bus_map_single(void *hwdev, void *ptr,
				 size_t size, int direction);
inline void bus_unmap_single(void *hwdev, dma_addr_t dma_addr,
			     size_t size, int direction);
void *bus_alloc_consistent(void *hwdev, size_t size,
			   dma_addr_t * dma_handle);
void bus_free_consistent(void *hwdev, size_t size,
                         void *vaddr, dma_addr_t dma_handle);

#define sysRegRead(phys)      (*(volatile u_int32_t *)phys)

#endif    /* _DEV_ATH_AHB_H_ */
