/*
 * Copyright (c) 2004 Atheros Communications Inc.  All rights reserved.
 */

#ifndef _NET_IF_ATH_PROTO_H_
#define _NET_IF_ATH_PROTO_H_

/*
 * Atheros proprietary protocol info.
 */
/*
 * Atheros proprietary SuperG defines.
 */

#define ATH_ETH_TYPE  0x88bd
#define ATH_SNAP_ORGCODE_0 0x00
#define ATH_SNAP_ORGCODE_1 0x03
#define ATH_SNAP_ORGCODE_2 0x7f

struct athl2p_tunnel_hdr {
#if (AH_BYTE_ORDER == AH_LITTLE_ENDIAN)
	u_int32_t  offset	: 11,
	seqNum       		: 11,
	optHdrLen32  		: 2,
	frameType    		: 2,
	proto        		: 6;
#else /* big endian */
	u_int32_t  proto	: 6,
	frameType    		: 2,
	optHdrLen32  		: 2,
	seqNum       		: 11,
	offset       		: 11;
#endif
} __packed;

#define ATH_SUPERG_FF 1 /* fast-frame compile option */
#define ATH_L2TUNNEL_PROTO_FF 0
/* FF max payload: 
 * 802.2 + FFHDR + HPAD + 802.3 + 802.2 + 1500 + SPAD + 802.3 + 802.2 + 1500:
 *   8   +   4   +  4   +   14  +   8   + 1500 +  6   +   14  +   8   + 1500
 * = 3066
 */ 
#define ATH_FF_MAX_HDR_PAD	4
#define ATH_FF_MAX_SEP_PAD	6
#define ATH_FF_MAX_HDR		30
#define ATH_FF_MAX_PAYLOAD 	3066
#define ATH_FF_MAX_LEN (ATH_FF_MAX_PAYLOAD + IEEE80211_CRC_LEN + \
    (IEEE80211_WEP_IVLEN + IEEE80211_WEP_KIDLEN + IEEE80211_WEP_CRCLEN))

/*
 * Store a magic number in skb->cb[] area to indicate FF within driver.
 * Offset of 8B into cb[] is used to preserve vlan tag info.
 */
#define ATH_FF_MAGIC	0x46415354	/* "FAST" in ascii */
#define ATH_FF_MAGIC_PUT(_skb) ((*(u_int32_t *)(&((_skb)->cb[8]))) = ATH_FF_MAGIC ) 
#define ATH_FF_MAGIC_CLR(_skb) ((*(u_int32_t *)(&((_skb)->cb[8]))) = 0 )
#define ATH_FF_MAGIC_PRESENT(_skb) \
	( (*((u_int32_t *) ( & ((_skb)->cb[8]) )) ) == ATH_FF_MAGIC ? 1 : 0 )

#define ATH_FF_TXQMIN 2

/*
 * Reserve enough buffer header length to avoid reallocation on fast-frame
 * rx and tx.
 */
#define USE_HEADERLEN_RESV 1

#endif /* _NET_IF_ATH_PROTO_H_ */
